#include<bits/stdc++.h>
using namespace std;

const int MAXN = 2e5+7;
int n, a[MAXN], seg[4*MAXN], dp[MAXN], maxi;
bool vis[MAXN];

void build(int idx, int l, int r)
{
    if(l == r)
    {
        seg[idx] = a[l];
        return;
    }
    int mid = (l+r)/2;
    build(idx*2, l, mid);
    build(idx*2+1, mid+1, r);
    seg[idx] = max(seg[idx*2], seg[idx*2+1]);
}

int query(int idx, int l, int r, int ql, int qr)
{
    if(l > qr || r < ql) return 0;
    if(ql <= l && r <= qr) return seg[idx];
    int mid = (l+r)/2;
    return max(query(idx*2, l, mid, ql, qr), query(idx*2+1, mid+1, r, ql, qr));
}

int f(int pos)
{
    if(pos > n || pos < 1) return 0;
    if(a[pos] == maxi) return 1;
    if(vis[pos]) return dp[pos];
    vis[pos] = true;
    int l = pos, r = n+1, mid;
    if(pos != n)
    {
        while(l < r-1)
        {
            mid = (l+r)/2;
            int curr = query(1, 1, n, pos+1, mid);
            if(curr > a[pos]) r = mid;
            else l = mid;
        }
        dp[pos] = max(dp[pos], f(r)+1);
    }
    l = 0;
    r = pos;
    if(pos != 1)
    {
        while(l < r-1)
        {
            mid = (l+r)/2;
            int curr = query(1, 1, n, mid, pos-1);
            if(curr > a[pos]) l = mid;
            else r = mid;
        }
        dp[pos] = max(dp[pos], f(l)+1);
    }
    //cout<<pos<<" "<<l<<"\n";
    return dp[pos];
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    cin>>n;
    for(int i = 1; i <= n; i++)
    {
        cin>>a[i];
        maxi = max(maxi, a[i]);
    }
    build(1, 1, n);
    int ans = 0;
    for(int i = 1; i <= n; i++)
    {
        ans = max(ans, f(i));
        cout<<i<<" "<<f(i)<<"\n";
    }
    cout<<ans;
    return 0;
}
