#include <iostream>
#include <algorithm>
#include <random>
#include <vector>
#include <cassert>
#include <queue>

const int MAXN = 2 * 1e5 + 10;
const int MAXLOG = 20 + 1;
const int INF = 1e9 + 10;

int n;
int a[MAXN];
bool bl[MAXN];
int dp[MAXN];

struct Sparse
{
    int log[MAXN];
    int table[MAXN][MAXLOG];

    void build(int arr[])
    {
        log[1] = 0;
        for(int i = 2 ; i <= n ; ++i)
        {
            log[i] = log[i / 2] + 1;
        }

        for(int i = 1 ; i <= n ; ++i)
        {
            table[i][0] = arr[i];
        }

        for(int j = 1 ; (1 << j) <= n ; ++j)
        {
            for(int i = 1 ; i + (1 << j) - 1 <= n ; ++i)
            {
                table[i][j] = std::max(table[i][j - 1], table[i + (1 << (j - 1))][j - 1]);
            }
        }
    }

    int query(int l, int r)
    {
        int j = log[r - l + 1];
        return std::max(table[l][j], table[r - (1 << j) + 1][j]);
    }
};

Sparse table;

int f(int i)
{
    if(bl[i]) return dp[i];
    bl[i] = 1;

    for(int j = 1 ; j <= n ; ++j)
    {
        if(i == j) continue;

        if(table.query(std::min(i, j), std::max(i, j)) == a[j])
        {
            dp[i] = std::max(dp[i], f(j) + 1);
        }
    }

    return dp[i];
}

void solve()
{
    table.build(a);

    int ans = -1;
    for(int i = 1 ; i <= n ; ++i)
    {
        std::fill(dp + 1, dp + n + 1, 0);
        std::fill(bl + 1, bl + n + 1, 0);
        ans = std::max(ans, f(i));
    }

    std::cout << ans + 1 << "\n";
}

void input()
{
    std::cin >> n;

    for(int i = 0 ; i < n ; ++i)
    {
        std::cin >> a[i];
    }
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    input();
    solve();

    return 0;
}