#include <iostream>
#include <algorithm>
#include <random>
#include <vector>
#include <cassert>
#include <queue>

const int MAXN = 2 * 1e5 + 10;
const int MAXLOG = 20 + 1;
const int INF = 1e9 + 10;

int n;
int a[MAXN];
int b[MAXN];
int dp[MAXN];

struct Sparse
{
    int log[MAXN];
    int table[MAXN][MAXLOG];

    void build(int arr[])
    {
        log[1] = 0;
        for(int i = 2 ; i <= n ; ++i)
        {
            log[i] = log[i / 2] + 1;
        }

        for(int i = 1 ; i <= n ; ++i)
        {
            table[i][0] = arr[i];
        }

        for(int j = 1 ; (1 << j) <= n ; ++j)
        {
            for(int i = 1 ; i + (1 << j) - 1 <= n ; ++i)
            {
                table[i][j] = std::max(table[i][j - 1], table[i + (1 << (j - 1))][j - 1]);
            }
        }
    }

    int query(int l, int r)
    {
        int j = log[r - l + 1];
        return std::max(table[l][j], table[r - (1 << j) + 1][j]);
    }
};

Sparse table;

void solve()
{
    table.build(a);

    std::iota(b + 1, b + n + 1, 1);
    std::sort(b + 1, b + n + 1, [&](int x, int y)
    {
        return a[x] < a[y];
    });

    std::fill(dp + 1, dp + n + 1, 1);

    for(int ptr = 1 ; ptr <= n ; ++ptr)
    {
        int i = b[ptr];
        for(int j = 1 ; j <= n ; ++j)
        {
            if(i == j) continue;

            if(table.query(std::min(i, j), std::max(i, j)) == a[j])
            {
                dp[j] = std::max(dp[j], dp[i] + 1);
            }
        }
    }
    
    int ans = -1;
    for(int i = 1 ; i <= n ; ++i)
    {
        //std::cout << dp[i] << " ";
        ans = std::max(ans, dp[i]);
    }

    //std::cout << "\n";
    std::cout << ans << "\n";
}

void input()
{
    std::cin >> n;

    for(int i = 0 ; i < n ; ++i)
    {
        std::cin >> a[i];
    }
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    input();
    solve();

    return 0;
}