#include <iostream>
#include <algorithm>
#include <vector>
#include <cassert>

const int MAXN = 2 * 1e5 + 10;
const int MAXLOG = 20 + 1;
const int INF = 1e9 + 10;

int n;
int a[MAXN];

struct Sparse
{
    int log[MAXN];
    int table[MAXN][MAXLOG];

    void build(int arr[])
    {
        log[1] = 0;
        for(int i = 2 ; i <= n ; ++i)
        {
            log[i] = log[i / 2] + 1;
        }

        for(int i = 1 ; i <= n ; ++i)
        {
            table[i][0] = arr[i];
        }

        for(int j = 1 ; (1 << j) <= n ; ++j)
        {
            for(int i = 1 ; i + (1 << j) - 1 <= n ; ++i)
            {
                table[i][j] = std::max(table[i][j - 1], table[i + (1 << (j - 1))][j - 1]);
            }
        }
    }

    int query(int l, int r)
    {
        int j = log[r - l + 1];
        return std::max(table[l][j], table[r - (1 << j) + 1][j]);
    }
};

Sparse table;
bool vis[MAXN];
std::vector<int> g[MAXN];

int dfs(int node)
{
    vis[node] = 1;

    int max = 0;
    for(int to : g[node])
    {
        if(!vis[to])
        {
            max = std::max(max, dfs(to));
        }
    }

    return 1 + max;
}

void solve()
{
    table.build(a);

    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = 1 ; j <= n ; ++j)
        {
            if(i == j) continue;

            if(table.query(std::min(i, j), std::max(i, j)) == a[j])
            {
                g[i].push_back(j);
            }
        }
    }

    int ans = -1;
    for(int i = 1 ; i <= n ; ++i)
    {
        std::fill(vis + 1, vis + n + 1, 0);
        //int res = dfs(i);
        ans = std::max(ans, dfs(i));
    }

    std::cout << ans + 1 << "\n";
}

void input()
{
    std::cin >> n;
    assert(n <= 20);

    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> a[i];
    }
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    input();
    solve();

    return 0;
}