#include <iostream>
#include <algorithm>
#include <vector>
#include <cmath>
#include <iomanip>

const int MAXN = 2 * 1e5 + 10;
const int INF = 1e9 + 10;

int t, n;
int a[MAXN];
int prefix[MAXN];

inline double calcRope(int l, int r)
{
    return std::sqrt((r - l) * (r - l) + (a[r] - a[l]) * (a[r] - a[l]));
}

inline double calcHeights(int l, int r)
{
    double res = 0;

    for(int i = l + 1 ; i <= r ; ++i)
    {
        res += std::abs(a[i] - a[i - 1]);
    }

    return res + (r - l);
}


void compute()
{
    std::cin >> n;

    for(int i = 1 ; i <= n ; ++i)
    {
        std::cin >> a[i];
    }

    double total = 0;
    for(int i = 1 ; i <= n ; ++i)
    {
        total += std::abs(a[i] - a[i - 1]);
    }

    total += 1 * n;

    double best = INF;
    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = i + 1 ; j <= n ; ++j)
        {
            if(a[i] > a[j]) continue;
            double current = total - calcHeights(i - 1, j) + calcRope(i, j);
            best = std::min(best, current);
        }
    }

    std::cout << std::setprecision(6) << std::fixed << best << "\n";
}

void solve()
{
    std::cin >> t;

    for(int i = 1 ; i <= t ; ++i)
    {
        compute();
    }
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    solve();

    return 0;
}