# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 2 * 1e5 + 1;
int n;
int a[MAXN];
int dp[MAXN];
vector<int> graph[MAXN];
int answer;

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

void read()
{
    cin >> n;
    stack<int> st;

    for(int i = 0; i < n; i++)
    {
        cin >> a[i];

        while(!st.empty() && a[st.top()] <= a[i])
        {
            if(a[st.top()] < a[i])
            {
                graph[st.top()].push_back(i);
            }

            st.pop();
        }

        if(!st.empty())
        {
            graph[i].push_back(st.top());
        }

        st.push(i);
    }
}

void dfs(int u, int current)
{
    answer = max(answer, current);
    if(dp[u] < current)
    {
        dp[u] = current;
    }
    else
    {
        return;
    }
    for(auto& v : graph[u])
    {
        dfs(v, current + 1);
    }
}

void solve()
{
    vector<pair<int, int>> h;

    for(int i = 0; i < n; i++) h.push_back({a[i], i});
    sort(h.begin(), h.end());

    for(auto& [_, u] : h)
    {
        dfs(u, 1);
    }

    cout << answer;
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}

/*
6 -> 7
4 -> 5
3 -> 5
2 -> 3
1 -> 2
0 -> 3
*/
