# include <bits/stdc++.h>
# define ll long long
using namespace std;

const int MAXN = 2 * 1e5 + 1;
int n;
int a[MAXN];
int dp[MAXN];
vector<int> graph[MAXN];
int answer;

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

void read()
{
    cin >> n;
    stack<int> st;

    for(int i = 0; i < n; i++)
    {
        cin >> a[i];

        while(!st.empty() && a[st.top()] < a[i])
        {
            st.pop();
        }

        if(!st.empty())
        {
            graph[i].push_back(st.top());
        }
        st.push(i);
    }

    while(!st.empty()) st.pop();

    for(int i = n - 1; i >= 0; i--)
    {
        while(!st.empty() && a[st.top()] < a[i])
        {
            st.pop();
        }

        if(!st.empty())
        {
            graph[i].push_back(st.top());
        }

        st.push(i);
    }
}

void dfs(int u)
{
    for(auto& v : graph[u])
    {
        if(dp[u] + 1 > dp[v])
        {
            dp[v] = dp[u] + 1;
            answer = max(answer, dp[v]);
            dfs(v);
        }
    }
}

void solve()
{
    for(int u = 0; u < n; u++) dp[u] = 1;

    for(int u = 0; u < n; u++)
    {
        if(dp[u] != 1) continue;
        dfs(u);
    }

    cout << answer;
}

int main()
{
    upgrade_speed();
    read();
    solve();
    return 0;
}

