# include <bits/stdc++.h>
# define ll long long
# define ld long double
using namespace std;

const int MAXN = 1e6 + 1;
const ld INF = 1e18;
int n;
ld h[MAXN];
ld dp[MAXN][2];

void upgrade_speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

void query()
{
    cin >> n;
    set<pair<ld, int>> sorted_h;

    for(int i = 1; i <= n; i++)
    {
        cin >> h[i];
        sorted_h.insert({h[i], i});
    }

    int optimal_index = n + 1;
    vector<ld> distance(n + 1);
    vector<int> rope(n + 1);

    for(auto& [height, index] : sorted_h)
    {
        rope[index] = n + 1;
        if(optimal_index < index)
        {
            rope[index] = optimal_index;
            distance[index] = sqrt((index - optimal_index) * (index - optimal_index) + (h[index] - h[optimal_index]) * (h[index] - h[optimal_index]));
        }

        optimal_index = min(optimal_index, index);
    }

    for(int i = 1; i <= n; i++)
    {
        ld climb = 1 + abs(h[i] - h[i - 1]);
        dp[i][0] = (dp[i - 1][0] + climb);
        dp[i][1] = dp[i][0];
        dp[i][1] = min(dp[i][1], climb + dp[i - 1][1]);
        if(rope[i] < i)
        {
            dp[i][1] = min(dp[i][1], (ld)(distance[i] + dp[rope[i]][0]));
        }
    }

    dp[n][0] += h[n];
    dp[n][1] += h[n];

    std::cout << std::setprecision(6) << fixed << dp[n][1] << '\n';
}

void solve()
{
    int t; cin >> t;
    while(t--) query();
}

int main()
{
    upgrade_speed();
    solve();
    return 0;
}
