#include <bits/stdc++.h>
using namespace std;

#define endl '\n'
#define out(x) #x << " = " << x << " "
#ifndef LOCAL
#define cerr if(false)cerr
#endif // LOCAL


const int MAX_N = 2 * 1e5;

int a[MAX_N];
int lft[MAX_N], rgt[MAX_N];

int mem[MAX_N];

int solve (int ind) {
    if (ind == -1) return 0;
    if (mem[ind]) return mem[ind];
    if (lft[ind] == rgt[ind] && lft[ind] == -1) {
        return mem[ind] = 1;
    }
    return mem[ind] = max(solve(lft[ind]), solve(rgt[ind])) + 1;
}

int main () {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n; cin >> n;
    for (int i = 0; i < n; i ++) {
        cin >> a[i];
        lft[i] = -1; rgt[i] = -1;
    }

    stack <pair<int, int>> st;
    for (int i = 0; i < n; i ++) {
        while (!st.empty() && st.top().second < a[i]) st.pop();
        if (!st.empty()) {
            lft[i] = st.top().first;
        }
        st.push({i, a[i]});
    }
    while(!st.empty()) st.pop();

    for (int i = n - 1; i >= 0; i --) {
        while (!st.empty() && st.top().second < a[i]) st.pop();
        if (!st.empty()) {
            rgt[i] = st.top().first;
        }
        st.push({i, a[i]});
    }

    int ans = 0;
    for (int i = 0; i < n; i ++) {
        ans = max(ans, solve(i));
    }
    cout << ans << endl;
    return 0;
}
