#include<iostream>
#include<vector>
#include<stack>
using namespace std;

const int MAX_N = 2e5 + 42;

int n, heights[MAX_N], max_height = -1;
bool visited[MAX_N];
vector<int> adj_list[MAX_N], reversed_adj_list[MAX_N];

void fast_io(){
    ios_base::sync_with_stdio(false);
    cin.tie(0);
}
void input(){
    cin >> n;
    for(int i = 0; i < n; ++i){
        cin >> heights[i];
        max_height = max(max_height, heights[i]);
    }
}

void make_adj_list(){ // n^2 sadly BUT NOT A PROBLEM!!!!
    for(int i = 0; i < n; ++i){
        // go rightwards
        int highest_so_far;
        highest_so_far = heights[i];
        for(int j = i + 1; j < n; ++j){
            // to swing to building j
            if( heights[i] < heights[j] && // it has to be taller than i
                heights[j] > highest_so_far // and the tallest so far
               ){
                adj_list[j].push_back(i);
                reversed_adj_list[i].push_back(j);
            }
            highest_so_far = max(highest_so_far, heights[j]);
            if(highest_so_far == max_height) break;
        }
        highest_so_far = heights[i];
        for(int j = i - 1; j >= 0; --j){
            // to swing to building j
            if( heights[i] < heights[j] && // it has to be taller than i
                heights[j] > highest_so_far // and the tallest so far
               ){
                adj_list[j].push_back(i);
                reversed_adj_list[i].push_back(j);
            }
            highest_so_far = max(highest_so_far, heights[j]);
            if(highest_so_far == max_height) break;
        }
    }
}

// max depth, vertex with that depth
pair<int, int> dfs(int start, bool reversed){
    for(int i = 0; i < n; ++i){
        visited[i] = false;
    }
    stack<pair<int, int>> st;
    st.push({start, 0});
    int max_depth = -1, vertex_max_depth = -1;
    while(!st.empty()){
        auto t = st.top(); st.pop();
        int v = t.first, depth = t.second;
        if(visited[v]) continue;
        //cout << v << " ";
        visited[v] = true;
        if(reversed){
            for(int u : reversed_adj_list[v]){
                st.push({u, depth + 1});
            }
        }else{
            for(int u : adj_list[v]){
                st.push({u, depth + 1});
            }
        }
        if(depth > max_depth){
            max_depth = depth;
            vertex_max_depth = v;
        }
    }
    return {max_depth, vertex_max_depth};
}

void solve(){
    int ans = 0;
    // longest path in a DAG is the answer

    int highest_degree = 0, HD = -1;
    for(int i = 0; i < n; ++i){
        if(adj_list[i].size() > highest_degree){
            highest_degree = adj_list[i].size();
            HD = i;
        }
    }
    if(HD == -1){ cout << "RIP"; return; }

    pair<int, int> dfs1 = dfs(HD, false);
    //cout << endl;
    pair<int, int> dfs2 = dfs(dfs1.second   , true);
   // cout << endl;

    cout << dfs1.first + dfs2.first;
}

int main(){
    fast_io();
    input();
    make_adj_list();
    /*for(int i = 0; i < n; ++i){
        cout << i << ": ";
        for(int v : adj_list[i]){
            cout << v << " ";
        }
        cout << endl;
    }*/
    solve();
    return 0;
}
