#include<iostream>
#include<vector>
#include<queue>
using namespace std;

const int MAX_N = 2e5 + 42;

int n, heights[MAX_N], max_height = -1;
vector<int> adj_list[MAX_N];

void fast_io(){
    ios_base::sync_with_stdio(false);
    cin.tie(0);
}
void input(){
    cin >> n;
    for(int i = 0; i < n; ++i){
        cin >> heights[i];
        max_height = max(max_height, heights[i]);
    }
}

void make_adj_list(){ // n^2 sadly BUT NOT A PROBLEM!!!!
    for(int i = 0; i < n; ++i){
        // go rightwards
        int highest_so_far;
        highest_so_far = heights[i];
        for(int j = i + 1; j < n; ++j){
            // to swing to building j
            if( heights[i] < heights[j] && // it has to be taller than i
                heights[j] > highest_so_far // and the tallest so far
               ){
                adj_list[j].push_back(i);
            }
            highest_so_far = max(highest_so_far, heights[j]);
            if(highest_so_far == max_height) break;
        }
        highest_so_far = heights[i];
        for(int j = i - 1; j >= 0; --j){
            // to swing to building j
            if( heights[i] < heights[j] && // it has to be taller than i
                heights[j] > highest_so_far // and the tallest so far
               ){
                adj_list[j].push_back(i);
            }
            highest_so_far = max(highest_so_far, heights[j]);
            if(highest_so_far == max_height) break;
        }
    }
}

void solve(){
    vector<int> candidates;
    for(int i = 0; i < n; ++i){
        if(heights[i] == max_height){
            candidates.push_back(i);
        }
    }
    int ans = 0;
    for(int v : candidates){
        // run a fucking BFS oh my god
        queue<pair<int, int>> q;
        q.push({v, 0});
        while(!q.empty()){
            auto t = q.front(); q.pop();
            int v = t.first, depth = t.second;
            for(int u : adj_list[v]){
                q.push({u, depth + 1});
            }
            ans = max(ans, depth);
        }
    }
    cout << ans + 1;
}

int main(){
    fast_io();
    input();
    make_adj_list();
    /*for(int i = 0; i < n; ++i){
        cout << heights[i] << ": ";
        for(int v : adj_list[i]){
            cout << heights[v] << " ";
        }
        cout << endl;
    }*/
    solve();
    return 0;
}
