#include <iostream>
#include <vector>
#include <algorithm>
#include <numeric>
#include <cassert>

std::pair<int, int> f(int n, int k)noexcept {
	int i, cand1, cand2, j, ans1{ 0 }, ans2{ 0 };
	std::vector<int> v(n);
	for (i = 0; i != n; ++i) {
		std::iota(v.begin(), v.end(), 1);
		cand1 = 0;
		cand2 = 0;
		for (j = i; v[j] != -1; j = (j + k) % n) {
			++cand1;
			cand2 += v[j];
			v[j] = -1;
		}
		if (cand2 > ans2) {
			ans1 = cand1;
			ans2 = cand2;
		}
	}
	return { ans1, ans2 };
}

int main() {
	// 1
	int n, k;
	std::cin >> n >> k;
	// 2
	int d;
	std::vector<int> v;
	for (d = 1; d * d <= n; ++d) {
		if (n % d == 0) {
			v.emplace_back(d);
			if (d * d != n) {
				v.emplace_back(n / d);
			}
		}
	}
	std::sort(v.begin(), v.end());
	// 3
	int ans1;
	long long ans2;
	auto const gauss = [](long long a, long long b, long long k)noexcept {
		return (a + b) * ((b - a) / k + 1) / 2;
		};
	int init{ -1 };
	for (auto const& e : v) {
		if (k % e == 0) {
			init = e;
		}
	}
	if (k == 1) {
		ans1 = n;
		ans2 = gauss(1, n, 1);
	}
	if (k == n) {
		ans1 = 1;
		ans2 = n;
	}
	else if (n % k == 0) {
		ans1 = (n - k) / k + 1;
		ans2 = gauss(k, n, k);
	}
	else if (init != -1) {
		ans1 = (n - init) / init + 1;
		ans2 = gauss(init, n, init);
	}
	else {
		ans1 = n;
		ans2 = gauss(1, n, 1);
	}
	// 3
	//auto const& [a, b] = f(n, k);
	//assert(a == ans1 && b == ans2);
	std::cout << ans1 << ' ' << ans2 << '\n';
	return 0;
}
