#include <iostream>
#include <vector>
#include <algorithm>
#include <iterator>

#include <unordered_map>

int main() {
	// 1
	int n;
	std::cin >> n;
	std::vector<int> v;
	v.reserve(n);
	std::copy_n(std::istream_iterator<int>{ std::cin }, n, std::back_inserter(v));
	// 2
	std::unordered_map<int, int> lut;
	for (auto const& e : v) {
		++lut[e];
	}
	// 3
	auto const gauss = [](int a, int b)noexcept {
		return (a + b) * (b - a + 1) / 2LL;
		};
	long long ans{ 0 };
	for (auto const& [e, cnt] : lut) {
		if (cnt < 2) {
			continue;
		}
		ans += gauss(1, cnt - 1) * (n - cnt);
	}
	// 4
	std::cout << ans << '\n';
	return 0;
}
