#include <iostream>
#include <vector>
using namespace std;
int dfs(vector<bool>& used, vector<vector<int>>& graph, int ind, int val) {
    used[ind] = 1;
    int max_value = 0;
    for (int i : graph[ind]) {
        if (!used[i]) {
            max_value = max(max_value, dfs(used, graph, i, val + 1));
        }
    }
    return max_value + 1;
}
int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, m;
    cin >> n >> m;
    vector<vector<int>> graph(n);
    for (int i = 0; i < m; i++) {
        int u, v;
        cin >> u >> v;
        graph[u].push_back(v);
        graph[v].push_back(u);
    }
    vector<int> counts;
    vector<bool> used(n);
    for (int i = 0; i < n; i++) {
        if (!used[i]) {
            counts.push_back(dfs(used, graph, i, 0));
        }
    }
    int count = 0;
    for (int i = 0; i < counts.size() - 1; i++) {
        for (int j = i + 1; j < counts.size(); j++) {
            count += counts[i] * counts[j];
        }
    }
    cout << count;
}