#include <bits/stdc++.h>
using namespace std;

const int MOD = 998244353;

// Факторизация на число
unordered_map<int,int> factorize(int x) {
    unordered_map<int,int> res;
    for (int d=2; d*d <= x; d++) {
        while (x % d == 0) {
            res[d]++;
            x /= d;
        }
    }
    if (x > 1) res[x]++;
    return res;
}

// Вектор на експонентите по простите множители на K
vector<int> get_exp_vector(int num, const vector<int>& primes, const vector<int>& limits) {
    if (num == -1) return {};
    vector<int> vec(primes.size());
    auto factors = factorize(num);
    for (size_t i=0; i<primes.size(); i++)
        vec[i] = min(factors[primes[i]], limits[i]);
    return vec;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, K;
    cin >> N >> K;
    vector<vector<int>> grid(N, vector<int>(N));
    for (int i=0;i<N;i++)
        for (int j=0;j<N;j++)
            cin >> grid[i][j];

    // Факторизация на K
    auto K_factors = factorize(K);
    vector<int> primes;
    vector<int> limits;
    for (auto &p : K_factors) {
        primes.push_back(p.first);
        limits.push_back(p.second);
    }
    int m = primes.size();

    // DP
    vector<vector<unordered_map<vector<int>, int>>> dp(N, vector<unordered_map<vector<int>, int>>(N));

    auto start_vec = get_exp_vector(grid[0][0], primes, limits);
    if (!start_vec.empty()) dp[0][0][start_vec] = 1;

    for (int i=0;i<N;i++) {
        for (int j=0;j<N;j++) {
            if (i==0 && j==0) continue;
            auto cell_vec = get_exp_vector(grid[i][j], primes, limits);
            if (cell_vec.empty()) continue;
            vector<pair<int,int>> dirs = {{-1,0},{0,-1}};
            for (auto [di,dj] : dirs) {
                int ni = i+di, nj = j+dj;
                if (ni<0 || nj<0) continue;
                for (auto &it : dp[ni][nj]) {
                    vector<int> new_vec(m);
                    for (int k=0;k<m;k++)
                        new_vec[k] = min(it.first[k]+cell_vec[k], limits[k]);
                    dp[i][j][new_vec] = (dp[i][j][new_vec]+it.second)%MOD;
                }
            }
        }
    }

    // Сумиране на крайни състояния
    int res = 0;
    for (auto &it : dp[N-1][N-1]) {
        bool ok = true;
        for (int k=0;k<m;k++)
            if (it.first[k]<limits[k]) { ok=false; break; }
        if (ok) res = (res + it.second)%MOD;
    }

    cout << res << "\n";
    return 0;
}
