#include <bits/stdc++.h>
using namespace std;
using ll = long long;
const int MOD = 998244353;

int addmod(int a, int b){ a += b; if(a >= MOD) a -= MOD; return a; }

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int N;
    long long K;
    if(!(cin >> N >> K)) return 0;

    vector<vector<int>> a(N+1, vector<int>(N+1));
    for(int i=1;i<=N;i++){
        for(int j=1;j<=N;j++){
            cin >> a[i][j];
        }
    }

    // Generate divisors of K
    vector<long long> divisors;
    for(long long d = 1; d*d <= K; ++d){
        if(K % d == 0){
            divisors.push_back(d);
            if(d*d != K) divisors.push_back(K / d);
        }
    }
    sort(divisors.begin(), divisors.end());
    int D = (int)divisors.size();
    unordered_map<long long,int> idx;
    idx.reserve(D*2);
    for(int i=0;i<D;i++) idx[divisors[i]] = i;

    // dp for previous row and current row:
    // prev[j][t] = number of ways to reach cell (i-1, j) with product = divisors[t]
    // cur[j][t]  = number of ways to reach cell (i, j) with product = divisors[t] (being filled)
    vector<vector<int>> prev(N+1, vector<int>(D, 0));
    vector<vector<int>> cur(N+1, vector<int>(D, 0));

    for(int i=1;i<=N;i++){
        // reset current row
        for(int j=0;j<=N;j++) fill(cur[j].begin(), cur[j].end(), 0);

        for(int j=1;j<=N;j++){
            if(a[i][j] == -1) continue; // blocked

            long long v = a[i][j];
            // Special case start cell
            if(i == 1 && j == 1){
                if(v != -1 && K % v == 0){
                    long long prod = v;
                    auto it = idx.find(prod);
                    if(it != idx.end()){
                        cur[j][it->second] = addmod(cur[j][it->second], 1);
                    }
                }
                continue;
            }

            // For each possible previous divisor dprev, collect counts from top and left
            for(int t = 0; t < D; ++t){
                int ways = 0;
                // from top
                ways = addmod(ways, prev[j][t]);
                // from left
                ways = addmod(ways, cur[j-1][t]); // cur[j-1] is left cell in current row

                if(ways == 0) continue;

                // compute new product = divisors[t] * v
                // if it exceeds K or not a divisor of K -> skip
                long long dprev = divisors[t];
                // guard overflow, but dprev and v <= 1e6 so product fits into 64-bit
                long long dnew = dprev * v;
                if(dnew > K) continue;
                if(K % dnew != 0) continue;
                auto it = idx.find(dnew);
                if(it != idx.end()){
                    int pos = it->second;
                    cur[j][pos] = (cur[j][pos] + ways) % MOD;
                }
            }
        }

        // move cur -> prev for next row
        prev.swap(cur);
    }

    // answer is number of ways to reach (N,N) with product exactly K
    int ans = 0;
    auto itK = idx.find(K);
    if(itK != idx.end()){
        ans = prev[N][itK->second];
    } else {
        ans = 0;
    }
    cout << ans % MOD << '\n';
    return 0;
}
