#include <iostream>
#include <algorithm>

const int MAXN = 1000000 + 10;

int n, k;
int a[MAXN];
int d[MAXN];
bool s[MAXN];

void print(long long x)
{
    if(x == 1)
    {
        std::cout << "1" << "\n";
        return;
    }

    for(long long p = 2; p * p <= x; ++p)
    {
        if (x % p == 0)
        {
            long long e = 0;
            while(x % p == 0)
            { 
                x /= p;
                ++e;
            }
            
            std::cout << p << " " << e << "\n";
        }
    }
}

void solve()
{
    std::cin >> n >> k;
    int m = n - k + 1;

    for(int i = 1; i <= m; ++i)
    {
        std::cin >> a[i];
    }

    for(int i = 1; i <= m - 1; ++i)
    {
        d[i] = a[i + 1] - a[i];
    }

    int c1 = a[1];
    int ans = 0;

    for(int mask = 0 ; mask < (1 << k) ; ++mask)
    {
        if(__builtin_popcount(mask) != c1)
        {
            continue;
        }

        for(int j = 0 ; j < k ; ++j)
        {
            s[1 + j] = ((mask >> j) & 1);
        }

        bool isOK = true;
        for(int i = 1 ; i <= m - 1 ; ++i)
        {
            if(d[i] == 0)
            {
                s[i + k] = s[i];
            }
            else if(d[i] == 1)
            {
                if(!s[i])
                {
                    s[i + k] = 1; 
                }
                else
                { 
                    isOK = false; 
                    break; 
                }
            }
            else
            {
                if(s[i])
                {
                    s[i + k] = 0;
                }
                else
                {
                    isOK = false;
                    break;
                }
            }
        }

        if(isOK) ans += 1;
    }

    std::cout << ans << "\n";
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    solve();

    return 0;
}
