#include <iostream>
#include <algorithm>
#include <vector>
#include <unordered_map>

const int MAXN = 500 + 5;
const int MOD = 998244353;

int n, m, k;
int table[MAXN][MAXN];
std::unordered_map<int, int> dp[MAXN][MAXN];

void pull(int i, int j, int fromI, int fromJ)
{
    for(int mod = 0 ; mod < m ; ++mod)
    {
        int x = mod;
        int y = table[i][j] % k;
        int pos = (x * y) % k;
        dp[i][j][pos] = (dp[i][j][pos] + dp[fromI][fromJ][mod]) % MOD;
    }
}

void solve()
{
    std::cin >> n >> k;
    m = k - 1;

    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = 1 ; j <= n ; ++j)
        {
            std::cin >> table[i][j];
        }
    }

    dp[1][1][table[1][1] % k] = 1;
    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = 1 ; j <= n ; ++j)
        {
            if(table[i][j] == -1) continue;

            if(i - 1 >= 1)
            {
                pull(i, j, i - 1, j);
            }

            if(j - 1 >= 1)
            {
                pull(i, j, i, j - 1);
            }
        }
    }

    std::cout << dp[n][n][0] << "\n";
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    solve();
    
    return 0;
}