#include <iostream>
#include <algorithm>
#include <vector>

const int MAXN = 500 + 5;
const int MAXK = 20;
const int MAXMOD = 19;
const int MOD = 998244353;

int n, k;
int table[MAXN][MAXN];
long long dp[MAXN][MAXN][MAXK];

void solve()
{
    std::cin >> n >> k;

    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = 1 ; j <= n ; ++j)
        {
            std::cin >> table[i][j];
        }
    }

    dp[1][1][table[1][1] % k] = 1;
    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = 1 ; j <= n ; ++j)
        {
            if(table[i][j] == -1) continue;

            if(i - 1 >= 1)
            {
                for(int m = 0 ; m <= MAXMOD ; ++m)
                {
                    int x = m;
                    int y = table[i][j] % k;
                    int pos = (x * y) % k;
                    dp[i][j][pos] = (dp[i][j][pos] + dp[i - 1][j][m]) % MOD;
                }
            }

            if(j - 1 >= 1)
            {
                for(int m = 0 ; m <= MAXMOD ; ++m)
                {
                    int x = m;
                    int y = table[i][j] % k;
                    int pos = (x * y) % k;
                    dp[i][j][pos] = (dp[i][j][pos] + dp[i][j - 1][m]) % MOD;
                }
            }
        }
    }

    std::cout << dp[n][n][0] << "\n";
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    solve();
    
    return 0;
}