#include <iostream>
#include <algorithm>
#include <vector>

const int MAXN = 10000 + 10;

int n, m;
std::vector<int> g[MAXN];
std::vector<int> components;
bool visited[MAXN];

int nodes;
void dfs(int node)
{
    nodes += 1;
    visited[node] = 1;

    for(int &to : g[node])
    {
        if(!visited[to])
        {
            dfs(to);
        }
    }
}

void solve()
{
    std::cin >> n >> m;

    for(int i = 1 ; i <= m ; ++i)
    {
        int a, b;
        std::cin >> a >> b;
        a += 1, b += 1;
        g[a].push_back(b);
        g[b].push_back(a);
    }

    for(int i = 1 ; i <= n ; ++i)
    {
        if(!visited[i])
        {
            nodes = 0;
            dfs(i);
            components.push_back(nodes);
        }
    }

    long long answer = 0;
    for(int i = 0 ; i < components.size() ; ++i)
    {
        for(int j = i + 1 ; j < components.size() ; ++j)
        {
            //std::cout << components[i] << " " << components[j] << "\n";
            answer += 1LL * components[i] * components[j];
        } 
    }

    std::cout << answer << "\n";
}

void fastIO()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);
}

int main()
{
    fastIO();
    solve();
    
    return 0;
}