#include <bits/stdc++.h>
#define int long long
using namespace std;
const int MAXN = 1e6;

bool used[MAXN + 5];
int br = 0;

struct union_find {
    int n;
    vector <int> sz, par;
    union_find(int _n) {
        n = _n;
        sz = par = vector <int> (n);
        for (int i = 1; i <= n; i++) {
            sz[i] = 1;
            par[i] = i;
        }
    }
    int find_par(int x) {
        if (par[x] == x) return x;
        return par[x] = find_par(par[x]);
    }
    void join (int x, int y) {
        x = find_par(x);
        y = find_par(y);
        if (x == y) return;
        if (sz[x] < sz[y]) swap(x, y);
        sz[x] += sz[y];
        par[y] = x;
    }
};

signed main() {
    int n, m; cin >> n >> m;
    union_find dsu(n);
    for (int i = 0; i < m; i++) {
        int x, y; cin >> x >> y; x++; y++;
        dsu.join(x, y);
    }
    int ans = 0;
    for (int i = 1; i <= n; i++) {
        int x = dsu.find_par(i);
        if (used[x]) continue;
        br = dsu.sz[x]; used[x] = true;
        ans += br * (n - br);
    }
    cout << ans / 2 << endl;
}
