#include <iostream>
#include <map>
#include <unordered_map>
using namespace std;

#define MAX_N 2 * 100000

long bipartite(long n, long m, long q) {
    unordered_map<long, long> tree(MAX_N);
    for (long i = 0; i < m; i++) {
        long a, b;
        cin >> a >> b;
        if (tree.find(a) != tree.end() && tree.find(b) != tree.end()) {
            if (tree[a] == tree[b]) return -1;
            continue;
        }
        if (tree.find(a) == tree.end() && tree.find(b) == tree.end()) {
            tree.insert(make_pair(a, 0));
            tree.insert(make_pair(b, 1));
            continue;
        }
        if (tree.find(a) == tree.end()) {
            tree.insert(make_pair(a, !tree[b]));
        } else {
            tree.insert(make_pair(b, !tree[a]));
        }
    }
    for (long j = 0; j < q; j++) {
        long a, b;
        cin >> a >> b;
        if (tree.find(a) != tree.end() && tree.find(b) != tree.end()) {
            if (tree[a] == tree[b]) return j + 1;
            continue;
        }
        if (tree.find(a) == tree.end() && tree.find(b) == tree.end()) {
            tree.insert(make_pair(a, 0));
            tree.insert(make_pair(b, 1));
            continue;
        }
        if (tree.find(a) == tree.end()) {
            tree.insert(make_pair(a, !tree[b]));
        } else {
            tree.insert(make_pair(b, !tree[a]));
        }
    }
    return -2;
}

long main() {
    long n, m, q;
    cin >> n >> m >> q;
    cout << bipartite(n, m, q);
    return 0;
}