#include <iostream>
#include <map>
#include <unordered_map>
using namespace std;

#define MAX_N 2 * 100000

int bipartite(int n, int m, int q) {
    unordered_map<int, int> tree(MAX_N);
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        if (tree.find(a) != tree.end() && tree.find(b) != tree.end()) {
            if (tree[a] == tree[b]) return -1;
            continue;
        }
        if (tree.find(a) == tree.end() && tree.find(b) == tree.end()) {
            tree.insert(make_pair(a, 0));
            tree.insert(make_pair(b, 1));
            continue;
        }
        if (tree.find(a) == tree.end()) {
            tree.insert(make_pair(a, !tree[b]));
        } else {
            tree.insert(make_pair(b, !tree[a]));
        }
    }
    for (int j = 0; j < q; j++) {
        int a, b;
        cin >> a >> b;
        if (tree.find(a) != tree.end() && tree.find(b) != tree.end()) {
            if (tree[a] == tree[b]) return j + 1;
            continue;
        }
        if (tree.find(a) == tree.end() && tree.find(b) == tree.end()) {
            tree.insert(make_pair(a, 0));
            tree.insert(make_pair(b, 1));
            continue;
        }
        if (tree.find(a) == tree.end()) {
            tree.insert(make_pair(a, !tree[b]));
        } else {
            tree.insert(make_pair(b, !tree[a]));
        }
    }
    return -2;
}

int main() {
    int n, m, q;
    cin >> n >> m >> q;
    cout << bipartite(n, m, q);
    return 0;
}