#include <iostream>
#include <tuple>
#include <vector>
using namespace std;

#define MAX_N 200000
#define MAX_M_Q 400000

// positive num - color
// 0 - not colored
// negative num - opposite color
int g_color[MAX_N + 1] = {0};
int current_color = 1;

pair<int, int> ribs[MAX_M_Q*2];

vector<int> connected[MAX_N];

int visited[MAX_N];
void changeColors(int vrux, int color_num)
{
    g_color[vrux] = color_num;
    visited[vrux] = true;
    color_num = -color_num;
    for(int i=0; i < connected[vrux].size(); i++)
    {
        if(!(visited[connected[vrux][i]]))changeColors(connected[vrux][i], color_num);
    }
}

// 0 - not bipartite
// 1 - bipartite
int isBipartite(int n, int num_ribs, int new_rib_index)
{
    for(int i = new_rib_index; i < num_ribs; i++)
    {
        int a, b;
        tie(a, b) = ribs[i];

        if(g_color[a] == g_color[b] && g_color[a] != 0) return 0;
        
        if(g_color[a] == 0 && g_color[b] != 0) g_color[a] = -g_color[b];
        else if(g_color[b] == 0 && g_color[a] != 0) g_color[b] = -g_color[a];
        else if(g_color[a] == 0 && g_color[b] == 0)
        {
            g_color[a] = current_color;
            g_color[b] = -current_color;
            current_color++;
        }
        else if(abs(g_color[a]) != abs(g_color[b]))
        {
            for(int i=0; i < n; i++)visited[i]=false;
            changeColors(b, -g_color[a]);
        }
    }
    return 1;
}

int main(void)
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n, m, q;

    cin >> n >> m >> q;

    for(int i=0; i < n; i ++)
    {
        connected[i].assign(n, 0);
    }

    for(int i = 0; i < m; i++)
    {
        cin >> ribs[i].first >> ribs[i].second;
        connected[ribs[i].first].push_back(ribs[i].second);
        connected[ribs[i].second].push_back(ribs[i].first);
    }

    if(!(isBipartite(n, m, 0))) cout << -1;
    else
    {
        int index = -2;
        for(int i = 0; i < q; i++)
        {
            cin >> ribs[m+i].first >> ribs[m+i].second;
            
            connected[ribs[m+i].first].push_back(ribs[m+i].second);
            connected[ribs[m+i].second].push_back(ribs[m+i].first);

            if(!(isBipartite(n, m+i+1, m+i))) index = i+1;
        }

        cout << index;
    }

    return 0;
}