#include <iostream>
using namespace std;

#define MAX_N 200000
#define MAX_M_Q 400000

// 1 - color 1
// 0 - not colored
// -1 - color 2
int g_color[MAX_N + 1] = {0};

pair<int, int> ribs[MAX_M_Q*2];

// 0 - not bipartite
// 1 - bipartite
int isBipartite(int n, int num_ribs, int new_rib_index)
{
    for(int i = new_rib_index; i < num_ribs; i++)
    {
        int a, b;
        tie(a, b) = ribs[i];

        if(g_color[a] == g_color[b] && g_color[a] != 0) return 0;
        
        if(g_color[a] == 0 && g_color[b] != 0) g_color[a] = -g_color[b];
        else if(g_color[a] != 0) g_color[b] = -g_color[a];
        else
        {
            g_color[a] = 1;
            g_color[b] = -1;
        }
    }
    return 1;
}

int main(void)
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n, m, q;

    cin >> n >> m >> q;

    for(int i = 0; i < m; i++)
    {
        cin >> ribs[i].first >> ribs[i].second;
    }

    if(!(isBipartite(n, m, 0))) cout << -1;
    else
    {
        int index = -2;
        for(int i = 0; i < q; i++)
        {
            cin >> ribs[m+i].first >> ribs[m+i].second;
            if(!(isBipartite(n, m+i+1, m+i))) index = i+1;
        }

        cout << index;
    }

    return 0;
}