#include <iostream>
#include <vector>
#include <queue>
#include <set>

typedef int ull;

struct Node
{
    bool colored;
    std::vector<ull> neighbour_nodes;
    Node()
    {
        colored = false;
        neighbour_nodes.resize(0);
    }
};

std::vector<Node> graph;

int flipGraphColor(ull start, ull v)
{
    std::queue<ull> que;
    std::set<ull> s;

    s.clear();

    que.push(start);
    ull current_el;
    while(!que.empty())
    {
        current_el = que.front();
        que.pop();

        if(current_el == v)
        {
            return 1;
        }

        if(s.find(current_el) != s.end())
        {
            continue;
        }

        graph[current_el].colored = !graph[current_el].colored;

        for(auto el : graph[current_el].neighbour_nodes)
        {
            if(s.find(el) == s.end())
            {
                que.push(el);
            }
        }
        s.insert(current_el);
    }

    return 0;
}

int main()
{
    std::ios_base::sync_with_stdio(false);
    ull n, m, q;
    std::cin >> n >> m >> q;

    graph.resize(n + 1);

    ull u, v;

    int output = 0;

    for(ull i = 1; i <= m; i++)
    {
        std::cin >> u >> v;
        if(output != 0)
            continue;
        
        if(graph[u].neighbour_nodes.size() == 0 && graph[v].neighbour_nodes.size() == 0)
        {
            graph[u].colored = true;
            graph[v].colored = false;
        }

        else if(graph[u].neighbour_nodes.size() == 0 && graph[v].neighbour_nodes.size() != 0)
        {
            graph[u].colored = !graph[v].colored;
        }
        else if(graph[u].neighbour_nodes.size() != 0 && graph[v].neighbour_nodes.size() == 0)
        {
            graph[v].colored = !graph[u].colored;
        }

        else //if(graph[u].neighbour_nodes.size() != 0 && graph[v].neighbour_nodes.size() != 0)
        {
            int o = flipGraphColor(u, v);
            if(o == 1)
            {
                output = -1;
            }
        }

        graph[u].neighbour_nodes.push_back(v);
        graph[v].neighbour_nodes.push_back(u);

    }

    std::cout << output << std::endl;

    return 0;
}