#include <iostream>
#include <vector>
#define MOD (unsigned long long)(1e9 + 7)

struct Node
{
    std::vector<int> neighbour_nodes;
    Node()
    {
        neighbour_nodes.reserve(0);
    }
};

int variation(int k, int n)
{
    int p = 1;
    int last = n - k + 1;
    while(n >= last)
    {
        p *= n--;
    }
    return p;
}

int numberOfTrees(int nb, int nd)
{
    return variation(3, nb - 1) * variation(2, nd - 1);
}

int main()
{

    int n, u, v;
    std::cin >> n;
    Node graph[n + 1];

    for(int i = 1; i < n; i++)
    {
        std::cin >> u >> v;
        graph[u].neighbour_nodes.push_back(v);
        graph[v].neighbour_nodes.push_back(u);
    }

    std::vector<int> atLeast4Neighbours;

    for(int i = 1; i <= n; i++)
    {
        if(graph[i].neighbour_nodes.size() >= 4)
        {
            atLeast4Neighbours.push_back(i);
        }
    }

    unsigned long long sum = 0;

    for(int i : atLeast4Neighbours)
    {
        for(int j : graph[i].neighbour_nodes)
        {
            if(graph[j].neighbour_nodes.size() >= 3)
            {
                //For each ordered pair (b, d) with b.neighbours >= 4 and d.neighbours >= 3
                std::cout << "(" << i << ", " << j << ") - " << numberOfTrees(graph[i].neighbour_nodes.size(), graph[j].neighbour_nodes.size()) << "\n";
                sum += numberOfTrees(graph[i].neighbour_nodes.size(), graph[j].neighbour_nodes.size());
                sum %= MOD;
            }
        }
    }

    std::cout << sum << std::endl;

    return 0;
}