#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

const int N = 2e5 + 2;

int col[N];
int used[N];
unordered_set <int> g[N];
int a[N], b[N];

bool dfs(int u, int c)
{
    if (g[u].empty())
    {
        return 1;
    }

    used[u] = 1;

    if (col[u] == c)
    {
        return 1;
    }

    if (col[u] != c && col[u] != 0)
    {
        return 0;
    }

    col[u] = c;

    for (int v : g[u])
    {
        if (!dfs(v, 3 - c))
        {
            return 0;
        }
    }

    return 1;
}

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int n, m, t;

    cin >> n >> m >> t;

    for (int i = 1; i <= m; i++)
    {
        int u, v;

        cin >> u >> v;

        if (g[u].find(v) != g[u].end())
        {
            continue;
        }

        g[u].insert(v);
        g[v].insert(u);
    }

    for (int i = 1; i <= n; i++)
    {
        if (used[i])
        {
            continue;
        }

        if (!dfs(i, 1))
        {
            cout << -1 << endl;

            return 0;
        }
    }

    for (int i = 1; i <= t; i++)
    {
        cin >> a[i] >> b[i];
    }

    for (int i = 1; i <= t; i++)
    {
        int u = a[i], v = b[i];

        for (int q = 1; q <= n; q++)
        {
            col[q] = 0;
        }

        g[u].insert(v), g[v].insert(u);

        bool f = dfs(u, 1);

        if (f)
        {
            continue;
        }

        for (int q = 1; q <= n; q++)
        {
            col[q] = 0;
        }

        bool f2 = dfs(u, 2);

        if (f2)
        {
            continue;
        }

        cout << i << endl;

        return 0;
    }

    cout << -2 << endl;

    return 0;
}
