# include <bits/stdc++.h>
# define llong long long
using namespace std;

const int MAXN = 2 * 1e5 + 1;
int N, M, Q;
int Color[MAXN];
int Root[MAXN], Size[MAXN];
vector<int> Graph[MAXN];
bool Flag = false;
int Answer = -2;
int Visited[MAXN], Mark;

int Change(const int& C)
{
    if(C == 1) return 2;
    return 1;
}

void Dfs_Clear(int U)
{
    if(Visited[U] == Mark)
    {
        return;
    }

    Visited[U] = Mark;
    Color[U] = 0;

    for(auto& V : Graph[U])
    {
        Dfs_Clear(V);
    }
}

void Update(int U)
{
    if(Visited[U] == Mark)
    {
        return;
    }

    Visited[U] = Mark;

    for(auto& V : Graph[U])
    {
        if(Color[V] == Color[U]) Flag = true;
        Color[V] = Change(Color[U]);
        Update(V);
    }
}

int Find(int U)
{
    if(Root[U] == U) return Root[U];
    return Root[U] = Find(Root[U]);
}

void Merge(int U, int V)
{
    int LeaderU = Find(U);
    int LeaderV = Find(V);

    if(LeaderU == LeaderV)
    {
        Graph[U].push_back(V);
        Graph[V].push_back(U);
        if(Color[U] == Color[V])
        {
            Flag = true;
            return;
        }

        return;
    }

    if(Size[LeaderU] < Size[LeaderV])
    {
        swap(U, V);
        swap(LeaderU, LeaderV);
    }

    if(Size[LeaderU] == 1)
    {
        Color[U] = 1;
        Color[V] = 2;
    }
    else
    {
        Mark++;
        Dfs_Clear(V);
        Color[V] = Change(Color[U]);
        Mark++;
        Update(V);
    }

    Root[LeaderV] = Root[LeaderU];
    Size[LeaderU] += Size[LeaderV];
    Graph[U].push_back(V);
    Graph[V].push_back(U);
}

void Upgrade_Speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

void Read()
{
    cin >> N >> M >> Q;
    for(int U = 1; U <= N; U++)
    {
        Root[U] = U;
        Size[U] = 1;
    }

    for(int i = 0; i < M; i++)
    {
        int U, V;
        cin >> U >> V;
        if(!Flag)
        {
            Merge(U, V);

            if(Flag)
            {
                Answer = -1;
            }
        }
    }
}

void Solve()
{
    for(int i = 1; i <= Q; i++)
    {
        int U, V;
        cin >> U >> V;
        if(!Flag)
        {
            Merge(U, V);

            if(Flag)
            {
                Answer = i;
            }
        }
    }

    cout << Answer;
}

int main()
{
    Upgrade_Speed();
    Read();
    Solve();
    return 0;
}
