# include <bits/stdc++.h>
# define llong long long
using namespace std;

const int MAXN = 2 * 1e5 + 1;
int N, M, Q;
vector<int> Graph[MAXN];
int Color[MAXN];
int Change[3] = {0, 2, 1};
int Root[MAXN];
int Size[MAXN];
int Visited[MAXN], Mark;

int Find_Root(int U)
{
    if(Root[U] == U) return Root[U];
    return Root[U] = Find_Root(Root[U]);
}

void Dfs(int U)
{
    if(Visited[U] == Mark) return;
    Visited[U] = Mark;

    for(auto& V : Graph[U])
    {
        Color[V] = Change[Color[U]];
        Dfs(V);
    }
}

void Print()
{
    for(int i = 1; i <= N; i++)
    {
        cout << "Vertex " << i << " is with Root " << Find_Root(i) << " and color " << Color[i] << '\n';
    }

    cout << '\n';
}

bool Merge(int U, int V)
{
    int RU, RV;
    RU = Find_Root(U);
    RV = Find_Root(V);

    if(RU == RV)
    {
        if(Color[U] == Color[V])
        {
            return false;
        }
        return true;
    }

    if(Size[RU] < Size[RV])
    {
        swap(U, V);
        swap(RU, RV);
    }

    if(Color[U] == 0 && Color[V] == 0)
    {
        Color[U] = 1;
        Color[V] = 2;
    }
    else
    {
        Color[V] = Change[Color[U]];
        Mark++;
        Dfs(V);
        Graph[U].push_back(V);
        Graph[V].push_back(U);
    }

    Root[RV] = Root[RU];
    Size[RU] += Size[RV];

    return true;
}

void Upgrade_Speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

void Read()
{
    cin >> N >> M >> Q;

    for(int i = 1; i <= N; i++)
    {
        Root[i] = i;
        Size[i] = 1;
    }

    bool Query;
    bool Over = false;
    int Answer = -2;

    for(int i = 0; i < M; i++)
    {
        int U, V;
        cin >> U >> V;

        if(!Over)
        {
            Query = Merge(U, V);
            if(!Query)
            {
                Over = true;
                Answer = -1;
            }
        }
    }

    for(int i = 1; i <= Q; i++)
    {
        int U, V; cin >> U >> V;
        if(!Over)
        {
            Query = Merge(U, V);
            if(!Query)
            {
                Over = true;
                Answer = i;
            }
        }
    }

    cout << Answer;
}

void Solve()
{

}

int main()
{
    Upgrade_Speed();
    Read();
    Solve();
    return 0;
}
