#include <bits/stdc++.h>
using namespace std;

#define out(x) #x << " = " << x << " "
#define endl '\n'
#ifndef LOCAL
    #define cerr if(false)cerr
#endif

const int MAX_N = 2 * 1e5 + 10;

int n, m, q;

int par[MAX_N];
int same[MAX_N];
int sz[MAX_N];

int color[MAX_N];

pair <int, int> getPS (int x) {
    if (par[x] == x) {
        return {x, same[x]};
    }
    pair<int, int> nP = getPS(par[x]);
    nP.second *= same[x];

    par[x] = nP.first;
    same[x] = nP.second;

    return nP;
}

int getColor (int x) {
    auto parent = getPS(x);

    if (parent.first == x) return color[x];
    return color[parent.first] * parent.second;
}

int getParent (int x) {
    auto parent = getPS(x);
    return par[x];
}

void combine (int x, int y) {
    int px = getParent(x), py = getParent(y);

    if (sz[px] < sz[py]){ swap(x, y); swap(px, py); }

    cerr << "comb: " << out(x) << out(y) << out(px) << out(py) << out(same[x]) << out(same[y]) << endl;

    if (same[x] == same[y]) {
        same[py] = -1;
    } else if (same[x] != same[y]) {
        same[py] = 1;
    }

    par[py] = px;
    sz[px] += sz[py];
}

int main () {
    #ifndef LOCAL
        ios_base::sync_with_stdio(false);
        cin.tie(NULL);
        cout.tie(NULL);
    #endif // LOCAL

    cin >> n >> m >> q;

    for (int i = 1; i <= n; i ++) {
        par[i] = i;
        color[i] = 1;
        same[i] = true;
        sz[i] = 1;
    }

    for (int i = 0; i < m; i ++) {
        int x, y;
        cin >> x >> y;
        int pX = getParent(x), pY = getParent(y);

        cerr << out(x) << out(y) << out(pX) << out(pY) << out(same[x]) << out(same[y]) << endl;

        if (pX == pY) {
            if (same[x] == same[y]) {
                cout << -1 << endl;
                return 0;
            }
        } else {
            combine(x, y);
        }
    }

    for (int v = 1; v <= n; v ++) {
        int parent = getParent(v);
        cerr << out(v) << out(parent) << out(same[v]) << out(color[v]) << endl;
    }

    for (int i = 0; i < q; i ++) {
        int x, y;
        cin >> x >> y;
        int pX = getParent(x), pY = getParent(y);

        cerr << out(x) << out(pX) << out(y) << out(pY) << endl;

        if (pX == pY) {
            if (same[x] == same[y]) {
                cout << i + 1 << endl;
                return 0;
            }
        } else {
            combine(x, y);
        }
    }

    cout << -2 << endl;

    return 0;
}

