#include<bits/stdc++.h>
using namespace std;
const int MAX_N = 2 * 1e5 + 1;
vector<vector<int> > adj;
bool visited[MAX_N];
int colored[MAX_N];
void dfs(int s, int previous_color, bool &bipartite)
{
    visited[s] = true;
    if(previous_color == 2)
    {
        colored[s] = 1;
        previous_color = 1;
    }
    else
    {
        if(previous_color == 1)
        {
            colored[s] = 2;
            previous_color = 2;
        }
    }
    for(auto i : adj[s])
    {
        if(visited[i] == true)
        {
            if(colored[i] == colored[s])
            {
                bipartite = false;
            }
        }
        if(visited[i] == false)
        {
            dfs(i, previous_color, bipartite);
        }
    }
}
int main ()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int n, m, q;
    cin>>n>>m>>q;
    int u, v;
    adj.resize(n + 1);
    for(int i = 0; i < m; i++)
    {
        cin>>u>>v;
        if(u != v)
        {
            adj[u].push_back(v);
            adj[v].push_back(u);
        }
    }
    bool bipartite = true;
    if(m != 0)
    {
        dfs(1, 2, bipartite);
    }
    if(bipartite == false)
    {
        cout<<-1<<endl;
    }
//    cout<<"Colored: "<<endl;
//    for(int i = 1; i <= n; i++)
//    {
//        cout<<colored[i]<<" ";
//    }
//    cout<<endl;
    for(int i = 1; i <= q; i++)
    {
        cin>>u>>v;
        if(u != v && bipartite == true)
        {
            if(colored[u] == 0 && colored[v] != 0)
            {
                if(colored[v] == 1)
                {
                    colored[u] = 2;
                }
                else
                {
                    colored[u] = 1;
                }
            }
            else
            {
                if(colored[v] == 0 && colored[u] != 0)
                {
                    if(colored[u] == 1)
                    {
                        colored[v] = 2;
                    }
                    else
                    {
                        colored[v] = 1;
                    }
                }
                else
                {
                    if(colored[u] == colored[v])
                    {
                        bipartite = false;
                        cout<<i<<endl;
                    }
                }
            }
        }
    }
    if(bipartite == true)
    {
        cout<<-2<<endl;
    }
    return 0;
}
