#include<bits/stdc++.h>
using namespace std;
const int MAX_N = 2 * 1e5 + 1;
vector<vector<int> > adj;
bool visited[MAX_N];
int colored[MAX_N];
void dfs(int s, int previous_color, bool &bipartite)
{
    visited[s] = true;
    if(previous_color == 2)
    {
        colored[s] = 1;
        previous_color = 1;
    }
    else
    {
        if(previous_color == 1)
        {
            colored[s] = 2;
            previous_color = 2;
        }
    }
    for(auto i : adj[s])
    {
        if(visited[i] == true)
        {
            if(colored[i] == colored[s])
            {
                bipartite = false;
            }
        }
        if(visited[i] == false)
        {
            dfs(i, previous_color, bipartite);
        }
    }
}
int main ()
{
    int n, m, q;
    cin>>n>>m>>q;
    int u, v;
    adj.resize(n + 1);
    bool bipartite = true;
    for(int i = 0; i < m; i++)
    {
        cin>>u>>v;
        if(u != v && bipartite == true)
        {
            adj[u].push_back(v);
            adj[v].push_back(u);
        }
    }
    if(m == 0)
    {
        cout<<-2<<endl;
    }
    else
    {
        dfs(1, 2, bipartite);
        if(bipartite == true)
        {
            cout<<-2<<endl;
        }
        else
        {
            cout<<-1<<endl;
        }
    }
    for(int i = 0; i < q; i++)
    {
        cin>>u>>v;
    }
    return 0;
}
