#include <iostream>
#include <vector>

const int MAX_N = 1000007;
int n, m, q;

int color[MAX_N];
int componenti = 0;
std::vector <int> comp[MAX_N];

bool add_rebro(int u, int v) {
    if (u == v) return false;

    if (color[u] != color[v] && color[u] != -color[v] && color[u] != 0 && color[v] != 0) {
        for (int i: comp[abs(color[v])]) {
            if (color[i] == color[v]) color[i] = -color[u];
            else if (color[i] == -color[v]) color[i] = color[u];
        }
        return true;
    }

    if (color[u] == color[v] && color[u] != 0) {
        return false;
    } else if (color[u] == 0 && color[v] != 0) {
        color[u] = -color[v];
        comp[abs(color[v])].push_back(u);
    } else if (color[u] != 0 && color[v] == 0 ) {
        color[v] = -color[u];
        comp[abs(color[u])].push_back(v);
    } else if (color[u] == 0 && color[v] == 0) {
        componenti++;
        color[u] = componenti; color[v] = -componenti;
        comp[componenti].push_back(u);
        comp[componenti].push_back(v);
    }
    return true;
}

int main() {
    for (int i = 0; i < MAX_N; i++) color[i] = 0;
    std::cin >> n >> m >> q;

    bool exited = false;
    for (int i = 0; i < m; i++) {
        int u, v; std::cin >> u >> v; u--; v--;
        if (exited) continue;
        if (!add_rebro(u, v)) {
            std::cout << -1;
            exited = true;
        }
    }

    for (int i = 0; i < q; i++) {
        int u, v; std::cin >> u >> v; u--; v--;
        if (exited) continue;
        if (!add_rebro(u, v)) {
            std::cout << i + 1;
            exited = true;
        }
    }

    if (exited) return 0;
    std::cout << -2;
    return 0;
}
