#include <iostream>
#include <vector>
#include <utility>

const int MAX_N = 1000007;
const int MOD = 1000000007;

int n;
std::vector <int> durvo[MAX_N];
std::vector <std::pair <int, int>> rebra;
int susedi[MAX_N];
int sumi[MAX_N];

int main() {
    std::cin >> n;
    for (int i = 0; i < (n - 1); i++) {
        int u, v; std::cin >> u >> v; u--; v--;
        durvo[u].push_back(v);
        durvo[v].push_back(u);
        rebra.push_back({ u, v });
    }

    for (int i = 0; i < n; i++) {
        susedi[i] = (durvo[i].size() - 1) * (durvo[i].size() - 2); sumi[i] = 0;
    }

    for (std::pair <int, int> &p: rebra) {
        int l = p.first, r = p.second;
        sumi[l] += susedi[r]; sumi[r] += susedi[l];
    }

    long long ans = 0;
    for (int b = 0; b < n; b++) {
        int cnt_all = durvo[b].size();
        if (cnt_all < 4) continue;

//        for (int d: durvo[b]) {
//            int cnt_d = durvo[d].size();
//            ans += (cnt_all - 1) * (cnt_all - 2) * (cnt_all - 3) * (cnt_d - 1) * (cnt_d - 2);
//        }
        ans += (cnt_all - 1) * (cnt_all - 2) * (cnt_all - 3) * sumi[b];
    }

    std::cout << ans % MOD;
}
