#include <bits/stdc++.h>
using namespace std;

const int MAXN = 200007;

int n, m, q;
vector<int> G[MAXN];
char color[MAXN];
int component[MAXN];
int flipped[MAXN];
int flipNo = 0;

int currComponent;
bool colorComponent(int curr, int prev=-1){
    char col = ((prev == -1 || color[prev] == 'g')?'y':'g');
    component[curr] = currComponent;
    if(color[curr] && color[curr] != col){
        return false;
    }else if(color[curr] == col){
        return true;
    }
    color[curr] = col;
    for(int i = 0; i < G[curr].size(); i++){
        if(G[curr][i] == prev){ continue; }
        bool result = colorComponent(G[curr][i], curr);
        if(!result){ return false; }
    }
    return true;
}

bool colorGraph(){
    for(int i = 0; i < n; i++){
        if(color[i]){ continue; }
        currComponent = i;
        bool result = colorComponent(i);
        if(!result){ return false; }
    }
    return true;
}

int comp(int x){
    if(component[x] != x){
        component[x] = comp(component[x]);
    }
    return component[x];
}

void flipComponent(int curr, int flipNo){
    color[curr] = (color[curr]=='y'?'g':'y');
    flipped[curr] = flipNo;
    for(int i = 0; i < G[curr].size(); i++){
        if(flipped[ G[curr][i] ] == flipNo){ continue; }
        flipComponent(G[curr][i], flipNo);
    }
}

void debugState(){
    for(int j = 0; j < n; j++){
        cout << j+1 << ": " << color[j] << ' ' << comp(j)+1 << ' ' << flipped[j] << '\n';
    }
}

int main(){
    cin >> n >> m >> q;
    int u, v;
    for(int i = 0; i < m; i++){
        cin >> u >> v;
        u--; v--;
        G[u].push_back(v);
        G[v].push_back(u);
    }

    vector<pair<int, int>> query;
    int loopNum = -1;
    for(int i = 0; i < q; i++){
        cin >> u >> v;
        u--; v--;
        if(u == v && loopNum == -1){ loopNum = i+1; }
        query.push_back({u, v});
    }

    bool bipartiteBefore = colorGraph();
    if(!bipartiteBefore){
        cout << "-1\n";
        return 0;
    }
    if(loopNum != -1){
        cout << loopNum << '\n';
        return 0;
    }
//    cout; debugState();

    for(int i = 0; i < q; i++){
        u = query[i].first; v = query[i].second;
        int cu = comp(u), cv = comp(v);
        if(cu == cv && color[u] == color[v]){
            cout << i+1 << '\n';
//            cout << u+1 << ' ' << cu+1 << ' ' << v+1 << ' ' << cv+1 << '\n';
//            cout; debugState();
            return 0;
        }
        if(cu != cv){
            if(color[u] == color[v]){
//                cout; debugState();
                flipComponent(v, ++flipNo);
//                cout << "flip component " << cv+1 << "(from " << v+1 << ")\n";
            }
//            cout << "connect " << u+1 << "(" << cu+1 << ") to " << v+1 << "(" << cv+1 << ")\n";
            component[cu] = cv;
            G[u].push_back(v);
            G[v].push_back(u);
        }
    }

    cout << "-2\n";

    return 0;
}
