#include <bits/stdc++.h>
using namespace std;

const int MAXN = 200007;

int n, m, q;
vector<int> G[MAXN];
char color[MAXN];
int component[MAXN];
int flipped[MAXN];
int flipNo = 0;

int currComponent;
bool colorComponent(int curr, int prev=-1){
    char col = ((prev == -1 || color[prev] == 'g')?'y':'g');
    component[curr] = currComponent;
    if(color[curr] && color[curr] != col){
        return false;
    }else if(color[curr] == col){
        return true;
    }
    color[curr] = col;
    for(int i = 0; i < G[curr].size(); i++){
        if(G[curr][i] == prev){
            continue;
        }
        bool result = colorComponent(G[curr][i], curr);
        if(!result){ return false; }
    }
    return true;
}

bool colorGraph(){
    for(int i = 0; i < n; i++){
        if(color[i]){ continue; }
        currComponent = i;
        bool result = colorComponent(i);
        if(!result){ return false; }
    }
    return true;
}

int comp(int x){
    if(component[x] != x){
        component[x] = comp(component[x]);
    }
    return component[x];
}

void flipComponent(int curr, int flipNo){
    color[curr] = (color[curr]=='y'?'g':'y');
    flipped[curr] = flipNo;
    for(int i = 0; i < G[curr].size(); i++){
        if(flipped[ G[curr][i] ] == flipNo){ continue; }
        flipComponent(G[curr][i], flipNo);
    }
}

int main(){
    cin >> n >> m >> q;
    int u, v;
    for(int i = 0; i < m; i++){
        cin >> u >> v;
        u--; v--;
        /// tuk purvonachalno napisah G[i]... SLAVA BOGU, che go hvanah vednaga, zashtoto tochno sushtoto neshto sum go debugval 2 chasa edin put
        G[u].push_back(v);
//        cout << "G[" << u << "].push_back(" << v << ")\n";
        G[v].push_back(u);
//        cout << "G[" << v << "].push_back(" << u << ")\n";
    }
//    for(int i = 0; i < n; i++){
//        cout << i+1 << ": ";
//        for(int j = 0; j < G[i].size(); j++){
//            cout << G[i][j]+1 << ' ';
//        }
//        cout << '\n';
//    }

    vector<pair<int, int>> query;
    int loopNum = -1;
    for(int i = 0; i < q; i++){
        cin >> u >> v;
        u--; v--;
        if(u == v && loopNum == -1){ loopNum = i+1; }
        query.push_back({u, v});
    }

//    for(int i = 0; i < q; i++){
//        cout << '\t' << query[i].first+1 << ' ' << query[i].second+1 << '\n';
//    }

    bool bipartiteBefore = colorGraph();
    if(!bipartiteBefore){
        cout << "-1\n";
        return 0;
    }
    if(loopNum != -1){
        cout << loopNum << '\n';
        return 0;
    }

    for(int i = 0; i < q; i++){
        u = query[i].first; v = query[i].second; /// mnogo sum tup, bqh napisal "u=" i na dvete...
        cout << "conn " << u+1 << '(' << color[u] << ") - " << v+1 << '(' << color[v] << ")\n";
        if(comp(u) == comp(v) && color[u] == color[v]){
            cout << i+1 << '\n';
            return 0;
        }
        int cu = comp(u), cv = comp(v);
        if(cu != cv){
            if(color[u] == color[v]){ flipComponent(v, ++flipNo); }
            component[cv] = cu;
        }
//        if(component[u] != component[v]){
//            if(componentLocked[ component[v] ] && !componentLocked[ component[u] ]){ swap(u, v); }
//            int cu = component[u], cv = component[v];
//            cout << "\tcomp[" << u+1 << "] = " << cu+1 << ", comp[" << v+1 << "] = " << cv+1 << '\n';
//            componentLocked[cu] = true;
//            if(componentLocked[cv]){
//                cout << "\tc(" << cv+1 << ") locked, checking...\n";
//                bool flip = (componentInverted[cu] != componentInverted[cv]);
//                if((color[u] == color[v]) != flip){
//                    cout << i+1 << '\n';
//                    return 0;
//                }
//            }else{
//                componentLocked[cv] = true;
//                bool flip = (color[u] == color[v]);
//                componentInverted[cv] = componentInverted[cu] != flip;
//                cout << "\tlocking (" << cv+1 << ") to " << (componentInverted[cv]?"inv":"nor") << '\n';
//            }
//        }
    }

    cout << "-2\n";

    return 0;
}
