#include <bits/stdc++.h>
using namespace std;

const int MAXN = 200007;

int n, m, q;
vector<int> G[MAXN];
char color[MAXN];
int component[MAXN];
bool componentInverted[MAXN];
bool componentLocked[MAXN];

int currComponent;
bool colorComponent(int curr, int prev=-1){
    char col = ((prev == -1 || color[prev] == 'g')?'y':'g');
    component[curr] = currComponent;
//    cout << "(" << curr+1 << ", " << prev+1 << "): \n";
    if(color[curr] && color[curr] != col){
//        cout << "\tcolored " << color[curr] << ": clash, return false;\n";
        return false;
    }else if(color[curr] == col){
//        cout << "\talready colored, skip\n";
        return true;
    }
    color[curr] = col;
    for(int i = 0; i < G[curr].size(); i++){
//        cout << "\t(" << curr+1 << ", " << prev+1 << ") -> (" << G[curr][i]+1 << ", " << curr+1 << ")\n";
        if(G[curr][i] == prev){
//            cout << "\t\t prev, skipping\n";
            continue;
        }
        bool result = colorComponent(G[curr][i], curr);
//        cout << "\t\tcomponent " << G[curr][i]+1 << "(from " << curr+1 << "): " << result << '\n';
        if(!result){ return false; }
    }
    return true;
}

bool colorGraph(){
    for(int i = 0; i < n; i++){
        if(color[i]){ continue; }
//        cout << "i = " << i << " (node " << i+1 << "): \n";
        currComponent = i;
        bool result = colorComponent(i);
//        cout << "component " << i+1 << ": " << result << '\n';
        if(!result){ return false; }
    }
    return true;
}

int main(){
    cin >> n >> m >> q;
    if(q != 0){ return 0; }
    int u, v;
    for(int i = 0; i < m; i++){
        cin >> u >> v;
        u--; v--;
        /// tuk purvonachalno napisah G[i]... SLAVA BOGU, che go hvanah vednaga, zashtoto tochno sushtoto neshto sum go debugval 2 chasa edin put
        G[u].push_back(v);
//        cout << "G[" << u << "].push_back(" << v << ")\n";
        G[v].push_back(u);
//        cout << "G[" << v << "].push_back(" << u << ")\n";
    }
//    for(int i = 0; i < n; i++){
//        cout << i+1 << ": ";
//        for(int j = 0; j < G[i].size(); j++){
//            cout << G[i][j]+1 << ' ';
//        }
//        cout << '\n';
//    }

    vector<pair<int, int>> query;
    for(int i = 0; i < q; i++){
        cin >> u >> v;
        u--; v--;
        query.push_back({u, v});
    }

//    for(int i = 0; i < q; i++){
//        cout << '\t' << query[i].first+1 << ' ' << query[i].second+1 << '\n';
//    }

    bool bipartiteBefore = colorGraph();
    if(!bipartiteBefore){
        cout << "-1\n";
        return 0;
    }

    for(int i = 0; i < q; i++){
        u = query[i].first; v = query[i].second; /// mnogo sum tup, bqh napisal "u=" i na dvete...
        if(component[u] == component[v] && color[u] == color[v]){
            cout << i+1 << '\n';
//            cout << u+1 << ' ' << v+1 << '\n';
            return 0;
        }
        if(component[u] != component[v]){
            componentLocked[u] = true;
            if(componentLocked[v]){
                bool flip = (componentInverted[u] != componentInverted[v]);
                if((color[u] == color[v]) != flip){
                    cout << i+1 << '\n';
                    return 0;
                }
            }else{
                componentLocked[v] = true;
                bool flip = (color[u] == color[v]);
                componentInverted[v] = componentInverted[u] != flip;
            }
        }
    }

    cout << "-2\n";

    return 0;
}
