#include <bits/stdc++.h>
using namespace std;
typedef unsigned long long ull;

const int MAXN = 1000007;
const ull MOD = 1000000007;

vector<int> G[MAXN];
int deg[MAXN];
ull hipsSize[MAXN]; /// when used as hips
int hipsNeigh[MAXN];
int n;

ull C[MAXN][4];

void precalcC(int upto){
    C[0][0] = 1;
    for(int i = 1; i <= upto; i++){
        C[i][0] = 1;
        C[i][1] = (1 + C[i-1][1]) % MOD;
        C[i][2] = (C[i-1][1] + C[i-1][2]) % MOD;
        C[i][3] = (C[i-1][2] + C[i-1][3]) % MOD;
    }
}

ull calcAsChest(int curr, int prv=-1){
    if(deg[curr] < 4 || hipsNeigh[curr] < 1) { return 0; }
    ull res = 0;
    for(int i = 0; i < deg[curr]; i++){
        const int nxt = G[curr][i];
        if(nxt != prv && hipsSize[nxt] > 0){
            ull chooseArmsAndHead = (3*2 * C[ deg[curr] - 1 ][3]) % MOD;
            res += (hipsSize[nxt] * chooseArmsAndHead) % MOD;
            res %= MOD;
        }
    }
    return res;
//    vector<ull> hipsPoss;
//    for(int i = 0; i < G[curr].size(); i++){
//        const int nxt = G[curr][i];
//        if(nxt != prv && hipsSize[nxt] > 0){
//            hipsPoss.push_back(hipsSize[nxt]);
//        }
//    }
//    if(hipsPoss.size() == 0){
//        return 0;
//    }
//    ull res = 0;
//    for(int i = 0; i < hipsPoss.size(); i++){
//        ull chooseArmsAndHead = (3*2 * C[ G[curr].size() - 1 ][3]) % MOD;
//        res += (hipsPoss[i] * chooseArmsAndHead) % MOD;
//        res %= MOD;
//    }
////        cout << curr+1 << ' ' << (type == CHEST ? "chest" : "hips") << ' ' << prv+1 << " -> " << res << '\n';
//    return res;
}

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    cin >> n;
    int mxNeigh = -1;
    for(int i = 0; i < n-1; i++){
        int u, v;
        cin >> u >> v;
        deg[--u]++; deg[--v]++;
        G[u].push_back(v);
        G[v].push_back(u);
        mxNeigh = max(mxNeigh, deg[u]);
        mxNeigh = max(mxNeigh, deg[v]);
    }

    if(mxNeigh < 4){ cout << "0\n"; return 0; }
    precalcC(mxNeigh);

    for(int i = 0; i < n; i++){
//        if(G[i].size() >= 3){
            hipsSize[i] = (2 * C[ deg[i]-1 ][2]) % MOD;
//        }
    }
//    return 0;
    for(int i = 0; i < n; i++){
        for(int j = 0; j < deg[i]; j++){
            hipsNeigh[i] += (hipsSize[G[i][j]] > 0);
        }
    }


    ull sum = 0;
    for(int i = 0; i < n; i++){
        sum += calcAsChest(i);
        sum %= MOD;
    }

    cout << sum << '\n';

    return 0;
}
