#include <bits/stdc++.h>
using namespace std;
typedef unsigned long long ull;

const int MAXN = 1000007;
const ull MOD = 1000000007;

vector<int> G[MAXN];
ull hipsSize[MAXN]; /// when used as hips
int n;

ull C[MAXN][4];

void precalcC(){
    C[0][0] = 1;
    for(int i = 1; i <= n; i++){
        C[i][0] = 1;
        for(int j = 1; j <= 3; j++){ /// smqtam samo do k=3
            C[i][j] = (C[i-1][j-1] + C[i-1][j]) % MOD;
        }
    }
}

ull calcAsChest(int curr, int prv=-1){
    if(G[curr].size() < 4) { return 0; }
    vector<ull> hipsPoss;
    for(int i = 0; i < G[curr].size(); i++){
        const int nxt = G[curr][i];
        if(nxt != prv && hipsSize[nxt] > 0){
            hipsPoss.push_back(hipsSize[nxt]);
        }
    }
    if(hipsPoss.size() == 0){
        return 0;
    }
    ull res = 0;
    for(int i = 0; i < hipsPoss.size(); i++){
        ull chooseArmsAndHead = (3*2 * C[ G[curr].size() - 1 ][3]) % MOD;
        res += (hipsPoss[i] * chooseArmsAndHead) % MOD;
        res %= MOD;
    }
//        cout << curr+1 << ' ' << (type == CHEST ? "chest" : "hips") << ' ' << prv+1 << " -> " << res << '\n';
    return res;
}

int main(){
    cin >> n;
    for(int i = 0; i < n-1; i++){
        int u, v;
        cin >> u >> v;
        u--; v--;
        G[u].push_back(v);
        G[v].push_back(u);
    }

    precalcC();

    for(int i = 0; i < n; i++){
        hipsSize[i] = (2 * C[ G[i].size()-1 ][2]) % MOD;
    }

    ull sum = 0;
    for(int i = 0; i < n; i++){
        sum += calcAsChest(i);
        sum %= MOD;
    }

    cout << sum << '\n';

    return 0;
}
