#include <bits/stdc++.h>

using namespace std;

const int maxn = 200005;

int n, m, q;
vector<int> g[maxn];

bool visited[maxn];
int color[maxn];
bool isColored[maxn];

bool isBipartite = true;

void dfs(int node)
{
    visited[node] = true;

    for (auto to : g[node])
    {
        if (visited[to] == false)
        {
            color[to] = 1 - color[node];
            isColored[to] = true;
            dfs(to);
        }
        else if (color[node] == color[to])
        {
            isBipartite = false;
        }
    }
}

pair<int, int> edges[maxn];

int par[maxn];
vector<int> components[maxn];

void init()
{
    for (int i = 1; i <= n; ++i)
    {
        par[i] = i;
        components[i].push_back(i);
    }
}

int root(int x)
{
    if (x == par[x]) return x;
    return par[x] = root(par[x]);
}

void connect(int x, int y)
{
    x = root(x);
    y = root(y);

    if (x == y) return;

    if (components[x].size() < components[y].size()) swap(x, y);

    par[y] = x;

    for (auto node : components[y]) components[x].push_back(node);
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n >> m >> q;

    init();

    for (int i = 1; i <= m; ++i)
    {
        int x, y;
        cin >> x >> y;

        g[x].push_back(y);
        g[y].push_back(x);

        connect(x, y);
    }

    for (int i = 1; i <= n; ++i)
    {
        if (visited[i] == false && g[i].size() >= 1)
        {
            color[i] = 0;
            isColored[i] = true;
            dfs(i);
        }
    }

    for (int i = 1; i <= q; ++i) cin >> edges[i].first >> edges[i].second;

    if (!isBipartite)
    {
        cout << -1 << endl;
        return 0;
    }

    for (int i = 1; i <= q; ++i)
    {
        int x = edges[i].first;
        int y = edges[i].second;

        if (isColored[x] && isColored[y])
        {
            if (color[x] != color[y])
            {
                connect(x, y);
                continue;
            }

            int rootX = root(x);
            int rootY = root(y);

            if (rootX == rootY && color[x] == color[y])
            {
                cout << i << endl;
                return 0;
            }

            if (components[rootX].size() < components[rootY].size()) swap(rootX, rootY);

            par[rootY] = rootX;

            for (auto node : components[rootY])
            {
                components[rootX].push_back(node);
                color[node] = 1 - color[node];
            }
        }
        else if (isColored[x] && !isColored[y])
        {
            connect(x, y);
            color[y] = 1 - color[x];
            isColored[y] = 1;
        }
        else if (!isColored[x] && isColored[y])
        {
            connect(x, y);
            color[x] = 1 - color[y];
            isColored[x] = 1;
        }
        else
        {
            connect(x, y);
            color[x] = 0; color[y] = 1;
            isColored[x] = isColored[y] = 1;
        }
    }

    cout << -2 << endl;

    return 0;
}
