#include <bits/stdc++.h>

using namespace std;

const int maxn = 1e6 + 5;
const int mod = 1e9 + 7;

int n;
vector<int> g[maxn];

long long calc(long long sz)
{
    long long curr = sz * (sz - 1);
    return curr % mod;
}

int parent[maxn], cntChilds[maxn], cntBottom[maxn], sum[maxn], cntMiddle[maxn], ans = 0;

void dfsInit(int node, int par)
{
    parent[node] = par;

    for (auto to : g[node])
    {
        if (to != par)
        {
            ++cntChilds[node];
            dfsInit(to, node);

            sum[node] += cntBottom[to];
            if (sum[node] >= mod) sum[node] -= mod;

            cntMiddle[node] += cntBottom[to];
            if (cntMiddle[node] >= mod) cntMiddle[node] -= mod;

            ans += cntMiddle[to];
            if (ans >= mod) ans -= mod;
        }
    }

    cntBottom[node] = calc(cntChilds[node]);
    cntMiddle[node] = ((1LL * cntMiddle[node]) * (1LL * calc(cntChilds[node] - 1))) % mod;
}

void calcAgain(int node)
{
    int p1 = parent[node];
    if (p1 == -1) return;

    if (parent[p1] != -1)
    {
        int p2 = parent[p1];
        int howMuch = (parent[p2] == -1 ? cntChilds[p2] - 1 : cntChilds[p2]);
        ans += (calc(cntChilds[p1] - 1) * calc(howMuch)) % mod;
        if (ans >= mod) ans -= mod;
    }

    int howMuch = (parent[p1] == -1 ? cntChilds[p1] - 2 : cntChilds[p1] - 1);
    long long sumWithout = (sum[p1] + mod - cntBottom[node]);
    ans += (calc(howMuch) * sumWithout) % mod;
    if (ans >= mod) ans -= mod;
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    for (int i = 1; i < n; ++i)
    {
        int x, y;
        cin >> x >> y;

        g[x].push_back(y);
        g[y].push_back(x);
    }

    dfsInit(1, -1);
    ans %= mod;

    for (int i = 1; i <= n; ++i)
    {
        calcAgain(i);
    }

    cout << ans % mod << endl;

    return 0;
}
