#include <bits/stdc++.h>
#pragma GCC optimize("Ofast")

using namespace std;

const int maxn = 1e6 + 5;
const long long mod = 1e9 + 7;

int n;
vector<int> g[maxn];

long long calc(long long sz)
{
    if (sz <= 1) return 0;
    long long curr = sz * (sz - 1);
    return curr % mod;
}

int parent[maxn], cntChilds[maxn];
long long cntBottom[maxn], ans = 0;
long long sum[maxn];
long long cntMiddle[maxn];

void dfsInit(int node, int par)
{
    parent[node] = par;

    for (auto to : g[node])
    {
        if (to != par)
        {
            ++cntChilds[node];
            dfsInit(to, node);

            sum[node] += cntBottom[to];
            sum[node] %= mod;
            cntMiddle[node] += cntBottom[to];
            ans += cntMiddle[to];
        }
    }

    cntBottom[node] = calc(cntChilds[node]);
    cntMiddle[node] %= mod;
    cntMiddle[node] = (cntMiddle[node] * calc(cntChilds[node] - 1)) % mod;
}

void calcAgain(int node)
{
    int p1 = parent[node];
    if (p1 == -1) return;

    if (parent[p1] != -1)
    {
        int p2 = parent[p1];
        int howMuch = (parent[p2] == -1 ? cntChilds[p2] - 1 : cntChilds[p2]);
        ans += (calc(cntChilds[p1] - 1) * calc(howMuch)) % mod;
    }

    int howMuch = (parent[p1] == -1 ? cntChilds[p1] - 2 : cntChilds[p1] - 1);
    long long sumWithout = (sum[p1] + mod - cntBottom[node]);
    ans += (calc(howMuch) * sumWithout) % mod;
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    for (int i = 1; i < n; ++i)
    {
        int x, y;
        cin >> x >> y;

        g[x].push_back(y);
        g[y].push_back(x);
    }

    dfsInit(1, -1);

    for (int i = 1; i <= n; ++i)
    {
        calcAgain(i);
    }

    cout << ans % mod << endl;

    return 0;
}
