#include <bits/stdc++.h>

using namespace std;

const int maxn = 1e6 + 5;
const long long mod = 1e9 + 7;

int n;
vector<int> g[maxn];

long long calc(long long sz)
{
    if (sz <= 1) return 0;
    long long curr = sz * (sz - 1);
    return curr % mod;
}

vector<int> childs[maxn];
int parent[maxn], cntChilds[maxn];
long long cntBottom[maxn], ans = 0;

void dfsInit(int node, int par)
{
    parent[node] = par;

    for (auto to : g[node])
    {
        if (to != par)
        {
            childs[node].push_back(to);
            ++cntChilds[node];
            dfsInit(to, node);
        }
    }

    cntBottom[node] = calc(childs[node].size());
}

void calcAgain(int node)
{
    for (int i = 0; i < childs[node].size(); ++i)
    {
        int child = childs[node][i];
        long long other = calc(childs[child].size() - 1);

        for (auto nxt : childs[child])
        {
            ans += (other * cntBottom[nxt]) % mod;
        }

        ans %= mod;
    }

    int p1 = parent[node];
    if (p1 == -1) return;

    if (parent[p1] != -1)
    {
        int p2 = parent[p1];
        //cout << "two " << node << " " << p1 << " " << p2 << " " << (calc(cntChilds[p1] - 1) * calc(cntChilds[p2] - 1)) << endl;
        ans += (calc(cntChilds[p1] - 1) * calc(cntChilds[p2])) % mod;
        ans %= mod;
    }

    for (int i = 0; i < childs[p1].size(); ++i)
    {
        int x = childs[p1][i];
        if (x == node) continue;
        ans += (cntBottom[x] * calc(childs[p1].size() - 1)) % mod;
        ans %= mod;
        //cout << node << " now " << x << " " << cntBottom[x] << " " << calc(allChilds[p1].size() - 1) << endl;
    }
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    for (int i = 1; i < n; ++i)
    {
        int x, y;
        cin >> x >> y;

        g[x].push_back(y);
        g[y].push_back(x);
    }

    dfsInit(1, -1);

    for (int i = 1; i <= n; ++i)
    {
        calcAgain(i);
    }

    cout << ans % mod << endl;

    return 0;
}
