#include <bits/stdc++.h>

using namespace std;

const int maxn = 1e6 + 5;
const int mod = 1e9 + 7;

int n;
vector<int> g[maxn];

long long calc(long long sz)
{
    if (sz <= 1) return 0;
    long long curr = sz * (sz - 1);
    return curr % mod;
}

long long cntBottom[maxn];
long long cntMiddle[maxn];
long long dp[maxn];
int cntChilds[maxn];
long long ans = 0;

int parent[maxn];
vector<int> allChilds[maxn];

void dfs1(int node, int par)
{
    parent[node] = par;

    vector<int> childs;

    for (auto to : g[node])
    {
        if (to != par)
        {
            childs.push_back(to);
            dfs1(to, node);
        }
    }

    cntChilds[node] = childs.size();
    allChilds[node] = childs;

    if (childs.size() >= 2)
    {
        cntBottom[node] = calc(childs.size());
    }

    if (childs.size() >= 3)
    {
        for (int i = 0; i < childs.size(); ++i)
        {
            cntMiddle[node] += (calc(childs.size() - 1) * cntBottom[childs[i]]) % mod;
        }

        cntMiddle[node] %= mod;
    }

    for (int i = 0; i < childs.size(); ++i)
    {
        dp[node] += cntMiddle[childs[i]];
    }

    dp[node] %= mod;
    ans += dp[node];
    ans %= mod;
}

void calcAgain(int node)
{
    int p1 = parent[node];
    if (p1 == -1) return;

    if (parent[p1] != -1)
    {
        int p2 = parent[p1];

        if (cntChilds[p1] >= 3 && cntChilds[p2] >= 3)
        {
            //cout << "two " << node << " " << p1 << " " << p2 << " " << (calc(cntChilds[p1] - 1) * calc(cntChilds[p2] - 1)) << endl;
            ans += (calc(cntChilds[p1] - 1) * calc(cntChilds[p2] - 1)) % mod;
            ans %= mod;
        }
    }

    for (int i = 0; i < allChilds[p1].size(); ++i)
    {
        int x = allChilds[p1][i];
        if (x == node) continue;
        ans += cntBottom[x] * calc(allChilds[p1].size() - 1);
        //cout << node << " now " << x << " " << cntBottom[x] << " " << calc(allChilds[p1].size() - 1) << endl;
    }
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    for (int i = 1; i < n; ++i)
    {
        int x, y;
        cin >> x >> y;

        g[x].push_back(y);
        g[y].push_back(x);
    }

    dfs1(1, -1);

    for (int i = 1; i <= n; ++i)
    {
        calcAgain(i);
    }

    cout << ans << endl;

    return 0;
}
