#include <bits/stdc++.h>

using namespace std;

const int maxn = 1e6 + 5;
const int mod = 1e9 + 7;

int n;
vector<int> g[maxn];

long long calc(long long sz)
{
    long long curr = sz * (sz - 1);
    return curr % mod;
}

long long cntBottom[maxn];
long long cntMiddle[maxn];
long long dp[maxn];
long long ans = 0;

void dfs1(int node, int par)
{
    vector<int> childs;

    for (auto to : g[node])
    {
        if (to != par)
        {
            childs.push_back(to);
            dfs1(to, node);
        }
    }

    if (childs.size() >= 2)
    {
        cntBottom[node] = calc(childs.size());
    }

    if (childs.size() >= 3)
    {
        for (int i = 0; i < childs.size(); ++i)
        {
            cntMiddle[node] += (calc(childs.size() - 1) * cntBottom[childs[i]]) % mod;
        }

        cntMiddle[node] %= mod;
    }

    for (int i = 0; i < childs.size(); ++i)
    {
        dp[node] += cntMiddle[childs[i]];
    }

    dp[node] %= mod;
    ans += dp[node];
    ans %= mod;
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    for (int i = 1; i < n; ++i)
    {
        int x, y;
        cin >> x >> y;

        g[x].push_back(y);
        g[y].push_back(x);
    }

    for (int i = 1; i <= n; ++i)
    {
        for (int j = 1; j <= n; ++j)
        {
            dp[j] = 0;
            cntBottom[j] = 0;
            cntMiddle[j] = 0;
        }
        dfs1(i, -1);
    }

    cout << ans << endl;

    return 0;
}
