#include <iostream>
#include <bitset>
#include <vector>
using namespace std;
const int maxN = 2e5 + 1;

vector<int> adj[maxN];
bitset<maxN> vis;
bitset<maxN> color;

bool colorGraph(int cur, bool col) {
    if (vis[cur]) {
        return (color[cur] == col);
    }
    vis[cur] = 1;
    color[cur] = col;
    for (int i = 0; i < adj[cur].size(); i++) {
        if (!colorGraph(adj[cur][i], !col)) {
            return false;
        }
    }
    return true;
}

void clearVis(int cur, int par, bool isFirst) {
    if (!vis[cur]) { return; }
    vis[cur] = 0;
    for (int i = 0; i < adj[cur].size(); i++) {
        if (isFirst && adj[cur][i] == par) {
            continue;
        }
        clearVis(adj[cur][i], par, 0);
    }
}

bool flipColor(int cur, int par, bool isFirst) {
    if (vis[cur]) {
        return true;
    }
    if (cur == par) {
        return false;
    }
    vis[cur] = 1;
    color[cur] = !color[cur];
    for (int i = 0; i < adj[cur].size(); i++) {
        if (isFirst && adj[cur][i] == par) {
            continue;
        }
        if (!flipColor(adj[cur][i], par, 0)) {
            return false;
        }
    }
    return true;
}

int main () {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int n, m, q;
    cin >> n >> m >> q;
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        a--; b--;
        adj[a].push_back(b);
        adj[b].push_back(a);
    }
    for (int i = 0; i < n; i++) {
        if (!vis[i] && !colorGraph(i, 0)) {
            cout << "-1\n";
            return 0;
        }
    }

    for (int i = 0; i < q; i++) {
        int a, b;
        cin >> a >> b;
        a--; b--;
        adj[a].push_back(b);
        adj[b].push_back(a);
        if (color[a] == color[b]) {
            clearVis(a, b, 1);
            if (!flipColor(a, b, 1)) {
                cout << i + 1 << "\n";
                return 0;
            }
        }
        //std::cout << '\n';
    }
    cout << "-2\n";
    return 0;
}
