#include <iostream>
#include <vector>
#include <stack>
#include <map>
#include <unordered_set>
#include <algorithm>
#include <iterator>
using namespace std;

int n, m, q;

int first_unchecked(bool arr[]) {
    for (int i=0; i < n; i++) {
        if (!arr[i]) return i;
    }
    return -1;
}


bool is_bipartite(map <int, vector<int>> graph) {
    unordered_set <int> blacks, whites;
    stack <int> for_checking;
    bool have_checked[n];
    for (int i=0; i < n; i++) {
        have_checked[i] = false;
    }
    int node, node_color;
    while (first_unchecked(have_checked) != -1) {
        if (for_checking.empty()) {
            node = first_unchecked(have_checked);
            blacks.insert(node);
        } else {
            node = for_checking.top();
            for_checking.pop();
        }
        if (graph.find(node) != graph.end()) {
            node_color = (blacks.find(node) != blacks.end()) ? 0 : 1;
            if (node_color == 0) {
                for (int n:graph[node]) {
                    whites.insert(n);
                    if (!have_checked[n]) for_checking.push(n);
                }
            }
            else {
                for (int n:graph[node]) {
                    blacks.insert(n);
                    if (!have_checked[n]) for_checking.push(n);
                }
            }
        }
        have_checked[node] = true;
        vector <int> intersection;
        set_intersection(blacks.begin(), blacks.end(),
                        whites.begin(), whites.end(),
                        back_inserter(intersection));
        if (intersection.size() > 0) {
            return false;
        }

        /* cout << "checked node " << node + 1 << endl;
        cout << "unchecked nodes:" << endl;
        for (auto n:have_checked) {
            cout << n << ' ';
        }
        cout << endl << "blacks:" << endl;
        for (auto n:blacks) {
            cout << n + 1<< ' ';
        }
        cout << endl << "whites:" << endl;
        for (auto n:whites) {
            cout << n + 1 << ' ';
        }
        cout << endl; */
    }
    return true;
}

int main() {
    cin >> n >> m >> q;
    map <int, vector <int>> graph;
    int n1, n2;
    vector <int> empty_vector;
    for (int i=0; i < m; i++) {
        cin >> n1 >> n2;
        n1 -= 1;
        n2 -= 1;
        if (graph.find(n1) == graph.end()) graph.insert(make_pair(n1, empty_vector));
        if (graph.find(n2) == graph.end()) graph.insert(make_pair(n2, empty_vector));
        graph[n1].push_back(n2);
        graph[n2].push_back(n1);
    }

    /* for (int i=0; i < n; i++) {
        cout << i + 1<< ": ";
        if (graph.find(i) != graph.end()) {
            for (int n:graph[i]) {cout << n + 1 << ' ';}
            cout << endl;
        }
    } */

    if (is_bipartite(graph)) {
        cout << -2;
    } else {
        cout << -1;
    }
    return 0;
}
