#include <iostream>;
#include <cmath>;
#include <map>;
using namespace std;

map <int, bool> memoize;

bool is_prime(int n) {
    if (memoize.find(n) != memoize.end()) { return memoize.at(n); }
    for (int i=2; i < pow(n, 0.5) + 1; i++) {
        if (n % i == 0) {
            memoize.insert(make_pair(n, false));
            return false;
        }
    }
    memoize.insert(make_pair(n, true));
    return true;
}

int primes(int a, int b) {
    int counter = 0;
    for (int i=a; i <= b; i++) {
        if (is_prime(i)) {
            counter++;
        }
    }
    return counter;
}

int main() {
    int a,b,N;
    cin >> N;
    for (int i=0; i < N; i++) {
        cin >> a >> b;
        cout << primes(a, b);
    }
    return 0;
}
