#include<bits/stdc++.h>
#define pb push_back

using namespace std;

typedef long long ll;
typedef pair<int, int> pii;

const int maxn=1e6+3;
const int mod=1e9+7;

int n, m;
vector<int> nbrs[maxn];
int par[maxn], rankk[maxn];
bool vis[maxn];
bool color[maxn];

bool dfs(int x, int y, bool col, int comp){
    vis[x]=true;
    color[x]=col;
    par[x]=comp;
    rankk[comp]++;

    for(auto u: nbrs[x]){
        if(u==x) continue;

        if(vis[u] and color[u]==col){
            ////cerr<<"problem at "<<u<<" and "<<x<<endl;
            return false;
        }
        if(!vis[u]){
            return dfs(u, x, !col, comp);
        }
    }

    return true;
}

bool check(){
    for(int i=1; i<=n; i++){
        if(!vis[i]){
            bool curr=dfs(i, 0, 0, i);
            if(!curr) return false;
        }
    }
    return true;
}

void change(int x, int y){
    vis[x]=true;
    color[x] = !color[x];

    //cerr<<"changed color of "<<x<<endl;

    for(auto u: nbrs[x]){
        if(!vis[u]) change(u, x);
    }

    return ;
}

int findd(int x){
    if(par[x]==x){
        return x;
    }

    return par[x]=findd(par[x]);
}

void unite(int x, int y){
    bool smen=false;
    if(color[x]==color[y]){
        //cerr<<"have to change colors when merging "<<x<<" and "<<y<<endl;
        smen=true;
    }

    int par_x=x;
    par_x=findd(par_x);
    int par_y=y;
    par_y=findd(par_y);

    if(rankk[par_x]<rankk[par_y]) swap(x, y);

    if(smen){
        for(int i=1; i<=n; i++) vis[i]=0;

        change(y, 0);
    }
    par[y]=par[x];
    rankk[par_x]+=rankk[par_y];
    rankk[par_y]=0;

    return ;
}

int main(){
ios_base::sync_with_stdio(false);
cin.tie(NULL);
cout.tie(NULL);

int q;
cin>>n>>m>>q;

for(int i=0; i<m; i++){
    int a, b;
    cin>>a>>b;
    nbrs[a].pb(b);
    nbrs[b].pb(a);
}

if(!check()){
    cout<<-1<<endl;
    return 0;
}

int ans=q+1;


for(int i=1; i<=q; i++){
    int a, b;
    cin>>a>>b;

    if(a!=b){
        if(findd(a)==findd(b)){
            if(color[a]==color[b]){
                //cerr<<"components of "<<a<<" and "<<b<<" are "<<findd(a)<<" and are colored the same"<<endl;
                ans=min(ans, i);
                break;
            }
        }else{
            //cerr<<"uniting "<<a<<" and "<<b<<endl;
            unite(a, b);

            nbrs[a].pb(b);
            nbrs[b].pb(a);
        }
    }
}

if(ans<=q){
    cout<<ans<<endl;
    return 0;
}

cout<<-2<<endl;
return 0;
}
